// GpMDoc.h : CGpMDoc Header file
//
/////////////////////////////////////////////////////////////////////////////


class CGpMDoc : public CDocument,public CMemSock 
{
protected:
	CGpMDoc();
	DECLARE_DYNCREATE(CGpMDoc)

// Attribute
public:
	BOOL   m_bConnected ;					// Linked with GP or not
	CString m_szIPAddress ;					// IP address of the GP that linked
	CString m_szTitle ;						// The file name of the title

    CObArray m_ContentsArry;				// Draw contents pool

	

// Operation
public:
	BOOL LinkMSock(LPCSTR szIPAddress);		// Linked MtoM socket

	CMemSock* GetCMemSock();

	void DeleteContents();					//  Delete Contents
	void AddContents(CContents  *pObject);	//  Add Contents
	CContents* GetContents(int nIndex);		//	Get Contents from pool
	int GetContentsCount();					//	Get Contents in the pool

	//	callback event
	void OnEventFunc(int iCode,DWORD dwParam1,DWORD dwParam2);


// Override
	// ClassWizard create the virtual methods and override them
	//{{AFX_VIRTUAL(CMRPODoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual void SetTitle(LPCTSTR lpszTitle);
	//}}AFX_VIRTUAL



// Implementation
public:
	virtual ~CGpMDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	void Agreeto();

// message map function that was generated
protected:
	//{{AFX_MSG(CGpMDoc)
	afx_msg void OnEditUndo();
	afx_msg void OnAllClear();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

public :
	CSize m_szGP ;
};

/////////////////////////////////////////////////////////////////////////////

extern void DispMtoMError( int iError,DWORD dwParticulars );
extern void ErrorBox(DWORD, ... );
extern CGpMDoc *GetIPAddressLinkedDocument(LPCTSTR szIPaddress);
